/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.api.crafting;

import blusunrize.immersiveengineering.api.crafting.IERecipeSerializer;
import blusunrize.immersiveengineering.api.crafting.IESerializableRecipe;
import blusunrize.immersiveengineering.api.crafting.IngredientWithSize;
import blusunrize.immersiveengineering.api.crafting.cache.CachedRecipeList;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.util.Lazy;
import net.minecraftforge.registries.RegistryObject;

public class CokeOvenRecipe
extends IESerializableRecipe {
    public static RecipeType<CokeOvenRecipe> TYPE;
    public static RegistryObject<IERecipeSerializer<CokeOvenRecipe>> SERIALIZER;
    public static final CachedRecipeList<CokeOvenRecipe> RECIPES;
    public final IngredientWithSize input;
    public final Lazy<ItemStack> output;
    public final int time;
    public final int creosoteOutput;

    public CokeOvenRecipe(ResourceLocation id, Lazy<ItemStack> output, IngredientWithSize input, int time, int creosoteOutput) {
        super(output, TYPE, id);
        this.output = output;
        this.input = input;
        this.time = time;
        this.creosoteOutput = creosoteOutput;
    }

    public boolean matches(ItemStack stack) {
        return this.input.test(stack);
    }

    protected IERecipeSerializer getIESerializer() {
        return (IERecipeSerializer)((Object)SERIALIZER.get());
    }

    public ItemStack m_8043_() {
        return (ItemStack)this.output.get();
    }

    public static CokeOvenRecipe findRecipe(Level level, ItemStack input) {
        return CokeOvenRecipe.findRecipe(level, input, null);
    }

    public static CokeOvenRecipe findRecipe(Level level, ItemStack input, @Nullable CokeOvenRecipe hint) {
        if (input.m_41619_()) {
            return null;
        }
        if (hint != null && hint.matches(input)) {
            return hint;
        }
        for (CokeOvenRecipe recipe : RECIPES.getRecipes(level)) {
            if (!recipe.matches(input)) continue;
            return recipe;
        }
        return null;
    }

    static {
        RECIPES = new CachedRecipeList<CokeOvenRecipe>(() -> TYPE, CokeOvenRecipe.class);
    }
}

